% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeat.R
\name{plotHeat}
\alias{plotHeat}
\title{Plotting Topics over Time relative to Corpus}
\usage{
plotHeat(
  object,
  ldaresult,
  ldaID,
  select = 1:nrow(ldaresult$document_sums),
  tnames,
  norm = FALSE,
  file,
  unit = "year",
  date_breaks = 1,
  margins = c(5, 0),
  ...
)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized \code{text}
component (calculation of proportion on document lengths) or
\code{\link{textmeta}} object which contains only the \code{meta} component
(calculation of proportion on count of words out of the LDA vocabulary in each
document)}

\item{ldaresult}{LDA result object.}

\item{ldaID}{Character vector containing IDs of the texts.}

\item{select}{Numeric vector containing the numbers of the topics to be plotted. Defaults to all topics.}

\item{tnames}{Character vector with labels for the topics.}

\item{norm}{Logical: Should the values be normalized by the mean topic share to account for differently sized topics (default: \code{FALSE})?}

\item{file}{Character vector containing the path and name for the pdf output file.}

\item{unit}{Character:  To which unit should dates be floored (default: \code{"year"})?
Other possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}}

\item{date_breaks}{How many labels should be shown on the x axis (default: \code{1})?
If \code{data_breaks} is \code{5} every fifth label is drawn.}

\item{margins}{See \code{\link{heatmap}}}

\item{...}{Additional graphical parameters passed to \code{\link{heatmap}},
for example \code{distfun} or \code{hclustfun}.
details The function is useful to search for peaks in the coverage of topics.}
}
\value{
A pdf.
Invisible: A dataframe.
}
\description{
Creates a pdf showing a heat map. For each topic, the heat map shows the deviation of
its current share from its mean share. Shares can be calculated on corpus level or on subcorpus level concerning LDA vocabulary.
Shares can be calculated in absolute deviation from the mean or relative to the mean of the topic to account for different topic strengths.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)
plotHeat(object=poliClean, ldaresult=LDAresult, ldaID=names(poliLDA))
}
}
