% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{ops_ps_roi_align}
\alias{ops_ps_roi_align}
\alias{nn_ps_roi_align}
\title{Performs Position-Sensitive Region of Interest (RoI) Align operator}
\usage{
ops_ps_roi_align(
  input,
  boxes,
  output_size,
  spatial_scale = 1,
  sampling_ratio = -1
)

nn_ps_roi_align(output_size, spatial_scale = 1, sampling_ratio = -1)
}
\arguments{
\item{input}{(\code{Tensor[N, C, H, W]}): The input tensor, i.e. a batch with \code{N} elements. Each element
contains \code{C} feature maps of dimensions \verb{H x W}.}

\item{boxes}{(\code{Tensor[K, 5]} or \code{List[Tensor[L, 4]]}): the box coordinates in (x1, y1, x2, y2)
format where the regions will be taken from.
The coordinate must satisfy \verb{0 <= x1 < x2} and \verb{0 <= y1 < y2}.
If a single Tensor is passed, then the first column should
contain the index of the corresponding element in the batch, i.e. a number in \verb{[1, N]}.
If a list of Tensors is passed, then each Tensor will correspond to the boxes for an element i
in the batch.}

\item{output_size}{(int or \code{Tuple[int, int]}): the size of the output (in bins or pixels) after the pooling
is performed, as (height, width).}

\item{spatial_scale}{(float): a scaling factor that maps the box coordinates to
the input coordinates. For example, if your boxes are defined on the scale
of a 224x224 image and your input is a 112x112 feature map (resulting from a 0.5x scaling of
the original image), you'll want to set this to 0.5. Default: 1.0}

\item{sampling_ratio}{(int): number of sampling points in the interpolation grid
used to compute the output value of each pooled output bin. If > 0,
then exactly \verb{sampling_ratio x sampling_ratio} sampling points per bin are used. If
<= 0, then an adaptive number of grid points are used (computed as
\code{ceil(roi_width / output_width)}, and likewise for height). Default: -1}
}
\value{
\code{Tensor[K, C / (output_size[1] * output_size[2]), output_size[1], output_size[2]]}:
The pooled RoIs
}
\description{
The (RoI) Align operator is mentioned in \href{https://arxiv.org/abs/1711.07264}{Light-Head R-CNN}.
}
\section{Functions}{
\itemize{
\item \code{nn_ps_roi_align}: The \code{\link[torch:nn_module]{torch::nn_module()}} wrapper for \code{\link[=ops_ps_roi_align]{ops_ps_roi_align()}}.
}}

\examples{
if (torch::torch_is_installed()) {
library(torch)
input <- torch_randn(1, 3, 28, 28)
boxes <- list(torch_tensor(matrix(c(1,1,5,5), ncol = 4)))
roi <- nn_ps_roi_align(output_size = c(1, 1))
roi(input, boxes)
}

}
