% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_mask_along_axis_iid}
\alias{functional_mask_along_axis_iid}
\title{Mask Along Axis IID (functional)}
\usage{
functional_mask_along_axis_iid(specgrams, mask_param, mask_value, axis)
}
\arguments{
\item{specgrams}{(Tensor): Real spectrograms (batch, channel, freq, time)}

\item{mask_param}{(int): Number of columns to be masked will be uniformly sampled from \verb{[0, mask_param]}}

\item{mask_value}{(float): Value to assign to the masked columns}

\item{axis}{(int): Axis to apply masking on (3 -> frequency, 4 -> time)}
}
\value{
\code{tensor}: Masked spectrograms of dimensions (batch, channel, freq, time)
}
\description{
Apply a mask along \code{axis}. Mask will be applied from indices \verb{[v_0, v_0 + v)}, where
\code{v} is sampled from \code{uniform (0, mask_param)}, and \code{v_0} from \code{uniform(0, max_v - v)}.
}
