% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-data-sampler.R
\name{sampler}
\alias{sampler}
\title{Creates a new Sampler}
\usage{
sampler(
  name = NULL,
  inherit = Sampler,
  ...,
  private = NULL,
  active = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{name}{(optional) name of the sampler}

\item{inherit}{(optional) you can inherit from other samplers to re-use
some methods.}

\item{...}{Pass any number of fields or methods. You should at least define
the \code{initialize} and \code{step} methods. See the examples section.}

\item{private}{(optional) a list of private methods for the sampler}

\item{active}{(optional) a list of active methods for the sampler.}

\item{parent_env}{used to capture the right environment to define the class.
The default is fine for most situations.}
}
\description{
Samplers can be used with \code{\link[=dataloader]{dataloader()}} when creating batches from a torch
\code{\link[=dataset]{dataset()}}.
}
\details{
A sampler must implement the \code{.iter} and \code{.lenght()} methods.
\itemize{
\item \code{initialize} takes in a \code{data_source}. In general this is a \code{\link[=dataset]{dataset()}}.
\item \code{.iter} returns a function that returns a dataset index everytime it's called.
\item \code{.length} returns the maximum number of samples that can be retrieved from
that sampler.
}
}
