% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrib.R
\name{contrib_sort_vertices}
\alias{contrib_sort_vertices}
\title{Contrib sort vertices}
\usage{
contrib_sort_vertices(vertices, mask, num_valid)
}
\arguments{
\item{vertices}{A Tensor with the vertices.}

\item{mask}{A tensors containing the masks.}

\item{num_valid}{A integer tensors.}
}
\description{
Based on the implementation from \href{https://github.com/lilanxiao/Rotated_IoU}{Rotated_IoU}
}
\details{
All tensors should be on a CUDA device so this function can be used.
}
\note{
This function does not make part of the official torch API.
}
\examples{
if (torch_is_installed()) {
if (cuda_is_available()) {
v <- torch_randn(8, 1024, 24, 2)$cuda()
mean <- torch_mean(v, dim=2, keepdim=TRUE)
v <- v - mean
m <- (torch_rand(8, 1024, 24) > 0.8)$cuda()
nv <- torch_sum(m$to(dtype = torch_int()), dim=-1)$to(dtype = torch_int())$cuda()
result <- contrib_sort_vertices(v, m, nv)
}
}
}
