% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_qr}
\alias{torch_qr}
\title{Qr}
\arguments{
\item{input}{(Tensor) the input tensor of size \eqn{(*, m, n)} where \code{*} is zero or more                batch dimensions consisting of matrices of dimension \eqn{m \times n}.}

\item{some}{(bool, optional) Set to \code{True} for reduced QR decomposition and \code{False} for                complete QR decomposition.}

\item{out}{(tuple, optional) tuple of \code{Q} and \code{R} tensors                satisfying \code{input = torch.matmul(Q, R)}.                The dimensions of \code{Q} and \code{R} are \eqn{(*, m, k)} and \eqn{(*, k, n)}                respectively, where \eqn{k = \min(m, n)} if \verb{some:} is \code{True} and                \eqn{k = m} otherwise.}
}
\description{
Qr
}
\note{
precision may be lost if the magnitudes of the elements of \code{input}
are large

While it should always give you a valid decomposition, it may not
give you the same one across platforms - it will depend on your
LAPACK implementation.
}
\section{qr(input, some=True, out=None) -> (Tensor, Tensor) }{


Computes the QR decomposition of a matrix or a batch of matrices \code{input},
and returns a namedtuple (Q, R) of tensors such that \eqn{\mbox{input} = Q R}
with \eqn{Q} being an orthogonal matrix or batch of orthogonal matrices and
\eqn{R} being an upper triangular matrix or batch of upper triangular matrices.

If \code{some} is \code{True}, then this function returns the thin (reduced) QR factorization.
Otherwise, if \code{some} is \code{False}, this function returns the complete QR factorization.
}

\examples{
if (torch_is_installed()) {

a = torch_tensor(matrix(c(12., -51, 4, 6, 167, -68, -4, 24, -41), ncol = 3, byrow = TRUE))
out = torch_qr(a)
q = out[[1]]
r = out[[2]]
torch_mm(q, r)$round()
torch_mm(q$t(), q)$round()
}
}
