% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_bincount}
\alias{torch_bincount}
\title{Bincount}
\arguments{
\item{input}{(Tensor) 1-d int tensor}

\item{weights}{(Tensor) optional, weight for each value in the input tensor.        Should be of same size as input tensor.}

\item{minlength}{(int) optional, minimum number of bins. Should be non-negative.}
}
\description{
Bincount
}
\section{bincount(input, weights=None, minlength=0) -> Tensor }{


Count the frequency of each value in an array of non-negative ints.

The number of bins (size 1) is one larger than the largest value in
\code{input} unless \code{input} is empty, in which case the result is a
tensor of size 0. If \code{minlength} is specified, the number of bins is at least
\code{minlength} and if \code{input} is empty, then the result is tensor of size
\code{minlength} filled with zeros. If \code{n} is the value at position \code{i},
\verb{out[n] += weights[i]} if \code{weights} is specified else
\verb{out[n] += 1}.

.. include:: cuda_deterministic.rst
}

\examples{
if (torch_is_installed()) {

input = torch_randint(0, 8, list(5), dtype=torch_int64())
weights = torch_linspace(0, 1, steps=5)
input
weights
torch_bincount(input, weights)
input$bincount(weights)
}
}
