% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_bartlett_window}
\alias{torch_bartlett_window}
\title{Bartlett_window}
\arguments{
\item{window_length}{(int) the size of returned window}

\item{periodic}{(bool, optional) If True, returns a window to be used as periodic        function. If False, return a symmetric window.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{None}, uses a global default (see \code{torch_set_default_tensor_type}). Only floating point types are supported.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned window tensor. Only          \code{torch_strided} (dense layout) is supported.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{None}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{False}.}
}
\description{
Bartlett_window
}
\note{
\preformatted{If `window_length` \eqn{=1}, the returned window contains a single value 1.
}
}
\section{bartlett_window(window_length, periodic=True, dtype=None, layout=torch.strided, device=None, requires_grad=False) -> Tensor }{


Bartlett window function.

\deqn{
    w[n] = 1 - \left| \frac{2n}{N-1} - 1 \right| = \left\{ \begin{array}{ll}
        \frac{2n}{N - 1} & \mbox{if } 0 \leq n \leq \frac{N - 1}{2} \\
        2 - \frac{2n}{N - 1} & \mbox{if } \frac{N - 1}{2} < n < N \\
    \end{array}
    \right. ,
}
where \eqn{N} is the full window size.

The input \code{window_length} is a positive integer controlling the
returned window size. \code{periodic} flag determines whether the returned
window trims off the last duplicate value from the symmetric window and is
ready to be used as a periodic window with functions like
\code{torch_stft}. Therefore, if \code{periodic} is true, the \eqn{N} in
above formula is in fact \eqn{\mbox{window\_length} + 1}. Also, we always have
\code{torch_bartlett_window(L, periodic=True)} equal to
\verb{torch_bartlett_window(L + 1, periodic=False)[:-1])}.
}

