% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_csv.R
\name{list_csv}
\alias{list_csv}
\alias{list_tsv}
\alias{list_rds}
\alias{list_rdata}
\title{Read multiple files from a directory into a list.}
\usage{
list_csv(path = ".", regexp = "[.]csv$", ignore.case = TRUE,
  invert = FALSE, ...)

list_tsv(path = ".", regexp = "[.]tsv$", ignore.case = TRUE,
  invert = FALSE, ...)

list_rds(path = ".", regexp = "[.]rds$", ignore.case = TRUE,
  invert = FALSE)

list_rdata(path = ".", regexp = "[.]rdata$|[.]rda$",
  ignore.case = TRUE, invert = FALSE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{regexp}{A regular expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{...}{Arguments passed to \code{readr::read_csv()} or \code{readr::read_tsv()}.}
}
\value{
A list.
}
\description{
These functions wrap the most common special cases of \code{\link[=list_any]{list_any()}}.
}
\examples{
(rds <- tor_example("rds"))
dir(rds)

list_rds(rds)

(tsv <- tor_example("tsv"))
dir(tsv)

list_tsv(tsv)

(mixed <- tor_example("mixed"))
dir(mixed)

list_rdata(mixed)

list_csv(mixed)

list_rdata(mixed, regexp = "[.]RData", ignore.case = FALSE)
}
\seealso{
Other general functions to import data: \code{\link{list_any}},
  \code{\link{load_csv}}
}
\concept{general functions to import data}
