% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectplot.R
\name{match_by_alleles}
\alias{match_by_alleles}
\title{Match the variants in the snpset by their alleles}
\usage{
match_by_alleles(df, verbose = NULL, show_full_output = FALSE)
}
\arguments{
\item{df}{A dataframe that is in the snpset format (like returned by the \code{\link{get_snpset}} function)}

\item{verbose}{A logical scalar (default: FALSE). Assign to TRUE to get information on which alleles are matched and which are not.}

\item{show_full_output}{A logical scalar (default:FALSE). Assign to TRUE to show the full output from this function}
}
\value{
The input dataframe containing only those variants with matched alleles in the snpset
}
\description{
\code{match_by_alleles()}
}
\examples{
\dontrun{
CD_UKBB_lead_snps <- get_lead_snps(CD_UKBB)
snpset <- get_snpset(CD_UKBB_lead_snps, CD_FINNGEN)
match_by_alleles(snpset$found)
}

}
