% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{vectorized_process_distance_matrix}
\alias{vectorized_process_distance_matrix}
\title{Vectorized Processing of Distance Matrix for Convergence Error Calculations}
\usage{
vectorized_process_distance_matrix(
  distances_numeric,
  threshold_mask,
  p_dist_mat
)
}
\arguments{
\item{distances_numeric}{Numeric matrix. The numeric distance values (without threshold
indicators)}

\item{threshold_mask}{Integer matrix. Codes representing threshold types:
1 for "greater than" (>), -1 for "less than" (<), or 0 for exact values}

\item{p_dist_mat}{Numeric matrix. The calculated distance matrix to compare against}
}
\value{
Numeric matrix with processed distance values. Elements where threshold
conditions are satisfied will contain NA.
}
\description{
Efficiently processes elements of the distance matrix for calculating convergence error
using pre-processed numeric representations of thresholds. This optimized version
eliminates expensive string operations during optimization.
}
\details{
This function handles threshold logic for convergence error calculation by using
pre-processed numeric matrices:
\itemize{
\item For "greater than" thresholds (threshold_mask = 1): Returns the numeric value if the
calculated distance is less than the threshold, otherwise returns NA
\item For "less than" thresholds (threshold_mask = -1): Returns the numeric value if the
calculated distance is greater than the threshold, otherwise returns NA
\item For regular values (threshold_mask = 0): Returns the numeric value
}

This function operates on entire matrices at once using vectorized operations,
which is significantly faster than processing each element individually.
}
\keyword{internal}
