% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{chart-shiny}
\alias{chart-shiny}
\alias{chartOutput}
\alias{renderChart}
\title{Shiny bindings for \code{\link[=chart]{chart()}}}
\usage{
chartOutput(outputId, width = "100\%", height = "400px")

renderChart(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{Must be a valid CSS unit (like \verb{100\%},
\verb{400px}, \code{auto}) or a number, which will be coerced to a
string and have \code{px} appended.}

\item{expr}{An expression that generates a calendar}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Output element that can be included in UI. Render function to create output in server.
}
\description{
Output and render functions for using \code{\link[=chart]{chart()}} within Shiny
applications and interactive Rmd documents.
}
\examples{
library(toastui)
library(shiny)

ui <- fluidPage(
  fluidRow(
    column(
      width = 8, offset = 2,
      tags$h2("Chart example"),
      selectInput("var", "Variable:", names(dimnames(Titanic))),
      chartOutput("mychart1"),
      chartOutput("mychart2")
    )
  )
)

server <- function(input, output, session) {
  
  output$mychart1 <- renderChart({
    Titanic \%>\% 
      as.data.frame() \%>\% 
      aggregate(as.formula(paste("Freq", input$var, sep = "~")), data = ., FUN = sum) \%>\% 
      chart(caes(x = !!as.symbol(input$var), y = Freq), type = "column")
  })
  
  output$mychart2 <- renderChart({
    req(input$var != "Survived")
    Titanic \%>\% 
      as.data.frame() \%>\% 
      aggregate(as.formula(paste("Freq ~ Survived", input$var, sep = "+")), data = ., FUN = sum) \%>\% 
      chart(caes(x = !!as.symbol(input$var), y = Freq, fill = Survived), type = "column")
  })
}

if (interactive())
  shinyApp(ui, server)
}
