% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getTableCounts}
\alias{getTableCounts}
\title{Counts number of rows and columns in the database tables.}
\usage{
getTableCounts(channel, schema = NULL, tableType = "TABLE",
  pattern = NULL, columns = FALSE, where = NULL, tables = NULL,
  test = FALSE, parallel = FALSE)
}
\arguments{
\item{channel}{object as returned by \code{\link{odbcConnect}}.}

\item{schema}{character vector with schemas to restric tables to one or more schemas. 
If \code{NULL} table search performed across whole database. Including \code{schema} restricts 
it to the specified schemas only.}

\item{tableType}{can specify zero or more types in separate elements of a character 
vector (one or more of \code{"TABLE", "VIEW", "SYSTEM TABLE", "ALIAS", "SYNONYM"}).}

\item{pattern}{character string containing \link{regular expression} to match table names (without
schema).}

\item{columns}{logical directs to include a column count for each table in the result.}

\item{where}{specifies criteria to satisfy by the table rows before applying computation. 
The creteria are expressed in the form of SQL predicates (inside \code{WHERE} clause).}

\item{tables}{optional pre-built list of tables (data frame returned by \code{\link{sqlTables}}).}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \link{RODBC} 
functions like \link{sqlQuery} and \link{sqlSave}).}

\item{parallel}{logical: enable parallel calls to Aster database. This option requires parallel 
backend enabled and registered (see in examples). Parallel execution requires ODBC \code{channel} 
obtained without explicit password: either with \code{\link{odbcConnect}(dsn)} or 
\code{\link{odbcDriverConnect}} calls, but not with \code{\link{odbcConnect}(dsn, user, password)}.}
}
\value{
a data frame returned by \code{\link{sqlTables}} augmented with \code{rowcount} (number of rows)
  and optinal \code{colcount} (number of columns) columns for each table.
}
\description{
Counts number of rows and columns in the database tables.
}
\examples{
if (interactive()) {

# initialize connection to Dallas database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")

table_counts = getTableCounts(conn, 'public')

library(reshape2)
library(ggplot2)
library(ggthemes)

data = melt(table_counts, id.vars='TABLE_NAME', measure.vars=c('rowcount','colcount'))
ggplot(data) +
  geom_bar(aes(TABLE_NAME, rowcount, fill=TABLE_NAME), stat='identity') +
  facet_wrap(~variable, scales = "free_y", ncol=1) +
  theme_tufte(ticks=FALSE) +
  theme(axis.text.x=element_text(size=12, angle=315, hjust=0),
        legend.position="none")
}
}

