% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getCharacterColumns}
\alias{getCharacterColumns}
\title{Filter character columns.}
\usage{
getCharacterColumns(tableInfo, names.only = TRUE, include = NULL,
  except = NULL)
}
\arguments{
\item{tableInfo}{data frame obtained by calling \code{\link{getTableSummary}}.}

\item{names.only}{logical: if TRUE returns column names only, otherwise full rows of \code{tableInfo}.}

\item{include}{a vector of column names to include. Output is restricted to this list.}

\item{except}{a vector of column names to exclude. Output never contains names from this list.}
}
\description{
Selects character columns (names or rows) from table info data frame.
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")

pitchingInfo = getTableSummary(channel=conn, 'pitching_enh')
getCharacterColumns(pitchingInfo)
char_cols_df = getCharacterColumns(pitchingInfo, names.only=FALSE)
}
}
\seealso{
\code{\link{getNumericColumns}}, \code{\link{getTemporalColumns}}, \code{\link{getTableSummary}}
}

