% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGraph.R
\name{computeGraphHistogram}
\alias{computeGraphHistogram}
\title{Compute various statistic distributions on graph edges and vertices.}
\usage{
computeGraphHistogram(channel, graph, type = "degree", weight = FALSE,
  binMethod = "manual", numbins = NULL, binsize = NULL,
  startvalue = NULL, endvalue = NULL, vertexWhere = graph$vertexWhere,
  edgeWhere = graph$edgeWhere, allTables = NULL, test = FALSE, ...)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}}

\item{graph}{an object of class \code{'toagraph'} referencing graph 
tables in Aster database.}

\item{type}{choose between graph measures to compute histogram distribution for: 
\code{'degree', 'clustering', 'shortestpath', 'pagerank', 'betweenness', 'eigenvector'}.}

\item{weight}{logical or character: if logical then \code{TRUE} indicates using \code{'weight'} edge
attribute, otherwise no weight used. If character then use as a name for the edge weight attribute. 
The edge weight may apply with types \code{'clustering', 'shortestpath'} and centrality measures.}

\item{binMethod}{one of several methods to determine number and size of bins: \code{'manual'} indicates to use 
paramters below, both \code{'Sturges'} or \code{'Scott'} will use corresponding methods of computing number
of bins and width (see \url{http://en.wikipedia.org/wiki/Histogram#Number_of_bins_and_width}).}

\item{numbins}{number of bins to use in histogram.}

\item{binsize}{size (width) of discrete intervals defining histogram (all bins are equal).}

\item{startvalue}{lower end (bound) of values to include in histogram.}

\item{endvalue}{upper end (bound) of values to include in histogram.}

\item{vertexWhere}{SQL WHERE clause limiting data from the vertex table. This value when not null
overrides corresponding value \code{vertexWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{edgeWhere}{SQL WHERE clause limiting data from the edge table. This value when not null
overrides corresponding value \code{edgeWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{allTables}{pre-built information about existing tables.}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}

\item{...}{other arguments passed on to Aster graph functions except for \code{EDGEWEIGHT} argument -
use argument \code{weight} instead. Aster function areguments are not casesensetive}
}
\description{
Compute various statistic distributions on graph edges and vertices.
}
\examples{
if(interactive()) {

policeGraphUn = toaGraph("dallaspolice_officer_vertices", "dallaspolice_officer_edges_un", 
                         directed = FALSE, key = "officer", 
                         source = "officer1", target = "officer2", 
                         vertexAttrnames = c("offense_count"), edgeAttrnames = c("weight"))
               
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
hdegreePolice = computeGraphHistogram(conn, policeGraphUn, type='degree', numbins=36) 
createHistogram(hdegreePolice, 
                title = "Dallas Police Graph Degree Distribution", 
                xlab='Degree', ylab='Count')

hshortestpathPolice = computeGraphHistogram(conn, policeGraphUn, type='shortestpath',
                              numbins = 10)
createHistogram(hshortestpathPolice, 
                title = "Dallas Police Shortest Path Distribution", 
                xlab = "Distance", ylab = "Count")
}
}

