% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_raster.R
\name{points_to_raster}
\alias{points_to_raster}
\title{Bin spatial points to a raster (deprecated)}
\usage{
points_to_raster(shp, nrow = NA, ncol = NA, N = 250000, by = NULL,
  to.Raster = NULL)
}
\arguments{
\item{shp}{shape object. a \code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}, a \code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}, or an \code{\link[sf:sf]{sf}} object that can be coerced as such.}

\item{nrow}{number of raster rows. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{ncol}{number of raster columns. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{N}{preferred number of raster cells.}

\item{by}{name of a data variable which should be a factor. The points are split and counted according to the levels of this factor.}

\item{to.Raster}{not used anymore, since the output is always a \code{\link[raster:Raster-class]{raster}} as of version 2.0}
}
\value{
a \code{RasterBrick} is returned when \code{by} is specified, and a \code{RasterLayer} when \code{by} is unspecified.
}
\description{
Bin spatial points to a raster. For each raster cell, the number of points are counted. Optionally, a factor variable can be specified by which the points are counts are split. Note that this function supports \code{sf} objects, but still uses sp-based methods (see details).
}
\details{
This function is a wrapper around \code{\link[raster:rasterize]{rasterize}}.

This function supports \code{\link[sf:sf]{sf}} objects, but still uses sp-based methods, from the packages sp, rgeos, and/or rgdal.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(NLD_muni, NLD_prov)

    # sample points (each point represents 1000 people)
    NLD_muni_points <- sample_dots(NLD_muni, vars = "population",
        w=1000, convert2density = TRUE)

    # dot map
    tm_shape(NLD_muni_points) + tm_dots()

    # convert points to raster
    NLD_rst <- points_to_raster(NLD_muni_points, N = 1e4)

    # plot raster
    tm_shape(NLD_rst) +
    	tm_raster() +
    tm_shape(NLD_prov) +
    	tm_borders() +
    tm_format("NLD") + tm_style("grey")
}
}
}
\seealso{
\code{\link{poly_to_raster}}
}
