% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{tmap_leaflet}
\alias{tmap_leaflet}
\title{Create a leaflet widget from a tmap object}
\usage{
tmap_leaflet(
  x,
  mode = "view",
  show = FALSE,
  add.titles = TRUE,
  in.shiny = FALSE,
  ...
)
}
\arguments{
\item{x}{tmap object. A tmap object is created with \code{\link{qtm}} or by stacking \code{\link{tmap-element}}s.}

\item{mode}{the mode of tmap, which is set to \code{"view"} in order to obtain the leaflet object. See \code{\link{tmap_mode}} for details.}

\item{show}{should the leaflet map be shown? \code{FALSE} by default}

\item{add.titles}{add titles to leaflet object}

\item{in.shiny}{is the leaflet output going to be used in shiny? If so, two features are not supported and therefore disabled: facets and colored backgrounds.}

\item{...}{arguments passed on to \code{\link{print.tmap}}}
}
\value{
\code{\link[leaflet:leaflet]{leaflet}} object
}
\description{
Create a leaflet widget from a tmap object. An interactive map (see \code{\link{tmap_mode}}) is an automatically generated leaflet widget. With this function, this leaflet widget is obtained, which can then be changed or extended by using leaflet's own methods.
}
\examples{
# world choropleth/bubble map of the world
data(World, metro)
metro$growth <- (metro$pop2020 - metro$pop2010) / (metro$pop2010 * 10) * 100

map1 <- tm_shape(metro) +
	tm_bubbles("pop2010", col = "growth", 
			   border.col = "black", border.alpha = .5, 
			   style="fixed", breaks=c(-Inf, seq(0, 6, by=2), Inf),
			   palette="-RdYlBu", contrast=1, 
			   title.size="Metro population", 
			   title.col="Growth rate (\%)", id="name") + 
	tm_layout(legend.bg.color = "grey90", legend.bg.alpha=.5, legend.frame=TRUE)


lf <- tmap_leaflet(map1)

# show leaflet widget
lf

# add marker
require(leaflet)
lf \%>\% leaflet::addMarkers(2.2945, 48.8582, popup = "Eiffel tower")

\dontrun{
# alternative
eiffelTower <- geocode_OSM("Eiffel Tower, Paris", as.SPDF = TRUE)

map1 + 
tm_shape(eiffelTower) +
	tm_markers()
}
}
\seealso{
\code{\link{tmapOutput}} for tmap in Shiny, \code{\link{tmap_mode}}, \code{\link{tm_view}}, \code{\link{print.tmap}}
}
