% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_add_legend.R
\name{tm_add_legend}
\alias{tm_add_legend}
\title{Add manual legend}
\usage{
tm_add_legend(type = c("fill", "symbol", "text", "line"), labels = NULL,
  col = NULL, size = NULL, shape = NULL, lwd = NULL, lty = NULL,
  text = NULL, alpha = NA, border.col = "black", border.lwd = 1,
  border.alpha = NA, title = "", is.portrait = TRUE, z = NA)
}
\arguments{
\item{type}{type of legend. One of \code{"fill"}, \code{"symbol"}, \code{"text"}, or \code{"line"}}

\item{labels}{legend labels}

\item{col}{legend colors}

\item{size}{legend symbol sizes (if \code{type=="symbol"})}

\item{shape}{legend symbol shapes (if \code{type=="symbol"})}

\item{lwd}{legend line widths (if \code{type=="line"})}

\item{lty}{legend line types (if \code{type=="line"})}

\item{text}{legend texts (if \code{type=="text"})}

\item{alpha}{legend fill transparancy}

\item{border.col}{legend border col (if \code{type} is \code{"fill"} or \code{"symbol"})}

\item{border.lwd}{legend border width (if \code{type} is \code{"fill"} or \code{"symbol"})}

\item{border.alpha}{legend border alpha (if \code{type} is \code{"fill"} or \code{"symbol"})}

\item{title}{legend title}

\item{is.portrait}{is legend portrait (\code{TRUE}) or landscape (\code{FALSE})}

\item{z}{legend stack position}
}
\description{
Creates a \code{\link{tmap-element}} that adds a manual legend.
}
\seealso{
\code{\link{tm_symbols}} for an example
}
