% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tm_shape}
\alias{tm_shape}
\title{Specify the shape object}
\usage{
tm_shape(shp, projection = NULL, xlim = NULL, ylim = NULL,
  relative = TRUE, bbox = NULL)
}
\arguments{
\item{shp}{shape object, which is one of
\itemize{
 \item{"1)"}\code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}
 \item{"2)"}\code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}
 \item{"3)"}\code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}
}
For drawing layers \code{\link{tm_fill}} and \code{\link{tm_borders}}, 1 is required. For drawing layer \code{\link{tm_lines}} 3 is required. Layers \code{\link{tm_bubbles}} and \code{\link{tm_text}}, accept any of them.}

\item{projection}{character that determines the projection. Either a \code{PROJ.4} character string (see \url{http://trac.ostm.org/proj/}), of one of the following shortcuts:
\describe{
       \item{\code{"longlat"}}{Not really a projection, but a plot of the longitude-latitude coordinates.}
       \item{\code{"wintri"}}{Winkel Tripel (1921). Popular projection that is useful in world maps. It is the standard of world maps made by the National tmgraphic Society. Type: compromise}
       \item{\code{"robin"}}{Robinson (1963). Another popular projection for world maps. Type: compromise}
       \item{\code{"eck4"}}{Eckert IV (1906). Projection useful for world maps. Area sizes are preserved, which makes it particularly useful for truthful choropleths. Type: equal-area}
       \item{\code{"hd"}}{Hobo-Dyer (2002). Another projection useful for world maps in which area sizes are preserved. Type: equal-area}
       \item{\code{"gall"}}{Gall (Peters) (1855). Another projection useful for world maps in which area sizes are preserved. Type: equal-area}
       \item{\code{"merc"}}{Mercator (1569). Projection in which shapes are locally preserved. However, areas close to the poles are inflated. Google Maps uses a close variant of the Mercator. Type: conformal}
       \item{\code{"mill"}}{Miller (1942). Projetion based on Mercator, in which poles are displayed. Type: compromise}
       \item{\code{"eqc0"}}{Equirectangular (120). Projection in which distances along meridians are conserved. The equator is the standard parallel. Also known as Plate Carr\'ee. Type: equidistant}
       \item{\code{"eqc30"}}{Equirectangular (120). Projection in which distances along meridians are conserved. The latitude of 30 is the standard parallel. Type: equidistant}
       \item{\code{"eqc45"}}{Equirectangular (120). Projection in which distances along meridians are conserved. The latitude of 45 is the standard parallel. Also known as Gall isographic. Type: equidistant}
       \item{\code{"rd"}}{Rijksdriehoekstelsel. Triangulation coordinate system used in the Netherlands.}}
       See \url{http://en.wikipedia.org/wiki/List_of_map_projections} for a overview of projections.
       By default, the projection is used that is defined in the \code{shp} object itself.}

\item{xlim}{limits of the x-axis}

\item{ylim}{limits of the y-axis}

\item{relative}{boolean that determines whether relative values are used for \code{xlim} and \code{ylim} or absolute. Note: relative values will depend on the current bounding box (bbox) of the first shape object.}

\item{bbox}{bounding box, which is a 2x2 matrix that consists absolute \code{xlim} and \code{ylim} values. If specified, it overrides the \code{xlim} and \code{ylim} parameters.}
}
\value{
\code{\link{tmap-element}}
}
\description{
This element specifies the shape object. Also the used projection and covered area (bounding box) can be set.
}
\examples{
data(World)

tm_shape(World, projection="longlat") + 
    tm_fill() +
    tm_borders() + 
    tm_layout("Long lat coordinates (WGS84)", inner.margins=c(0,0,.1,0), title.cex=.8)

World$highlighted <- ifelse(World$iso_a3 \%in\% c("GRL", "AUS"), "gold", "gray75")
tm_shape(World, projection="merc") + 
    tm_fill("highlighted") + 
    tm_borders() + 
    tm_layout("Mercator projection. Although used in Google Maps, it is discouraged for
statistical purposes. In reality, Australia is 3 times larger than Greenland!", 
inner.margins=c(0,0,.1,0), title.cex=.6)


tm_shape(World, projection="wintri") + 
    tm_fill() + 
    tm_borders() + 
    tm_layout(
"Winkel-Tripel projection, adapted as default by the National Geographic Society for world maps", 
inner.margins=c(0,0,.1,0), title.cex=.8)

tm_shape(World) +
    tm_fill() + 
    tm_borders() + 
tm_layout("Eckhart IV projection. Recommended in statistical maps for its equal-area property", 
    inner.margins=c(0,0,.1,0), title.cex=.8)
}
\seealso{
\code{\link{set_projection}}, \href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

