% Generated by roxygen2 (4.0.1): do not edit by hand
\name{animation_tmap}
\alias{animation_tmap}
\title{Create animations}
\usage{
animation_tmap(expr, width = 1000, height = 1000, delay = 40,
  filename = "animation.gif")
}
\arguments{
\item{expr}{R expression to create series of tm plots. In order to create a series of plots, which are combined to an animation, it is important to set nrow and ncol in \code{\link{tm_facets}} such that nrow * ncol < [number of small multiples]. In most situations, where one map is shown, both nrow and ncol are set to 1.}

\item{width}{width of the animation file (in pixels)}

\item{height}{height of the animation file (in pixels)}

\item{delay}{delay time between images}

\item{filename}{filename of the video (should be a .gif or .mpg file)}
}
\description{
This function creates a gif or mpeg animation from a tm plot. The free tool ImageMagick is required.
}
\examples{
\dontrun{
data(Europe)

animation_tmap({
	tm_shape(Europe) +
		tm_fill("yellow") +
		tm_borders() +
		tm_facets(by = "name", nrow=1,ncol=1) +
		tm_layout(scale=2)
}, width=1200, height=800, filename="my_animation.gif")
}
}
\keyword{animation}

