% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Extract Posterior Summaries of Target Parameters}
\usage{
extract(x)
}
\arguments{
\item{x}{An object of class \code{summary_fitsae} or \code{benchmark_fitsae}.}
}
\value{
An object of class \code{estimates_fitsae}, being a list of two data frames, distinguishing between \verb{$in_sample} and \verb{$out_of_sample} areas, which gathers domains name, direct and HB estimates, as well as posterior summaries of target parameters. When the input is a \code{benchmark_fitsae} object, benchmarked estimates are also included.
}
\description{
The \code{extract()} function provides the posterior summaries of target parameters, including model-based estimates, and possibly benchmarked estimates, related to a fitted small area model.
}
\examples{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    # MCMC setting to obtain a fast example. Remove next line for reliable results.
                    chains = 1, iter = 300, seed = 0)

# check model diagnostics
summ_beta <- summary(fit_beta)

# extract model estimates
HB_estimates <- extract(summ_beta)
head(HB_estimates)


}
\seealso{
\code{\link{summary.fitsae}} and \code{\link{benchmark}} to produce the input object.
}
