% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip_with_binary.R
\name{tip_with_binary}
\alias{tip_with_binary}
\alias{tip_b}
\title{Tip a result with a binary confounder.}
\usage{
tip_with_binary(
  effect,
  exposed_p = NULL,
  unexposed_p = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

tip_b(
  effect,
  exposed_p = NULL,
  unexposed_p = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome effect
(assumed to be the exponentiated coefficient, so a relative risk, odds
ratio, or hazard ratio). This can be the point estimate, lower confidence
bound, or upper confidence bound.}

\item{exposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{correction_factor}{Character string. Options are "none", "hr", "or".
For common outcomes (>15\%), the odds ratio or hazard ratio is not a good
estimate for the relative risk. In these cases, we can apply a correction
factor. If you are supplying a hazard ratio for a common outcome, set
this to "hr"; if you are supplying an odds ratio for a common outcome, set
this to "or"; if you are supplying a risk ratio or your outcome is rare,
set this to "none" (default).}
}
\description{
Choose two of the following three to specify, and the third will be estimated:
\itemize{
\item \code{exposed_p}
\item \code{unexposed_p}
\item \code{outcome_association}
}

Alternatively, specify all three and the function will return the number of unmeasured
confounders specified needed to tip the analysis.
}
\details{
\code{\link[=tip_b]{tip_b()}} is an alias for \code{\link[=tip_with_binary]{tip_with_binary()}}.
}
\examples{
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip_with_binary(1.2, exposed_p = 0.5, unexposed_p = 0)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip_with_binary(1.2,
  exposed_p = 0.5,
  unexposed_p = 0,
  outcome_association = 1.1)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   dplyr::pull(conf.low) \%>\%
   tip_with_binary(exposed_p = 1, outcome_association = 1.15)
}
}
