% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_posterior_data.R
\name{create_posterior_data}
\alias{create_posterior_data}
\title{Creates posterior distributions for a range of weights on the informative component of the robust MAP prior}
\usage{
create_posterior_data(map_prior, new_trial_data, sigma, null_effect = 0)
}
\arguments{
\item{map_prior}{A MAP prior containing information about the trial(s) in the source population, created using \code{RBesT}.}

\item{new_trial_data}{A vector containing information about the new trial. See \code{create_new_trial_data()}.}

\item{sigma}{Standard deviation to be used for the weakly informative component of the MAP prior, recommended to be the unit-information standard deviation.}

\item{null_effect}{The mean of the robust component of the MAP prior. Defaults to 0.}
}
\value{
A data frame containing posterior distributions for varying weights
}
\description{
Returns a data frame containing the default quantiles of posterior mixture distributions
generated with varying weights on the informative component of the MAP prior.
}
\examples{

# create vector containing data on new trial
new_trial_data <- create_new_trial_data(
  n_total = 30,
  est = 1.27,
  se = 0.95
)

# read MAP prior created by RBesT
map_prior <- load_tipmap_data("tipmapPrior.rds")

# create posterior data
\dontrun{
posterior_data <- create_posterior_data(
  map_prior = map_prior,
  new_trial_data = new_trial_data,
  sigma = 12
)
}
}
\references{
Best, N., Price, R. G., Pouliquen, I. J., & Keene, O. N. (2021).
Assessing efficacy in important subgroups in confirmatory trials: An example
using Bayesian dynamic borrowing. Pharm Stat, 20(3), 551–562.
https://doi.org/10.1002/pst.2093
}
\seealso{
\code{\link{create_new_trial_data}}, \code{\link{create_prior_data}}
}
