% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{latexmk}
\alias{latexmk}
\alias{pdflatex}
\alias{xelatex}
\alias{lualatex}
\title{Compile a LaTeX document to PDF}
\usage{
latexmk(file, engine = c("pdflatex", "xelatex", "lualatex"), bib_engine = c("bibtex", 
    "biber"), engine_args = NULL, emulation = TRUE, max_times = 10, 
    install_packages = emulation && tlmgr_available())

pdflatex(...)

xelatex(...)

lualatex(...)
}
\arguments{
\item{file}{A LaTeX file path.}

\item{engine}{A LaTeX engine (can be set in the global option
\code{tinytex.engine}, e.g., \code{options(tinytex.engine = 'xelatex')}).}

\item{bib_engine}{A bibliography engine (can be set in the global option
\code{tinytex.bib_engine}).}

\item{engine_args}{Command-line arguments to be passed to \code{engine} (can
be set in the global option \code{tinytex.engine_args}, e.g.,
\code{options(tinytex.engine_args = '-shell-escape'}).}

\item{emulation}{Whether to emulate the executable \command{latexmk} using R.}

\item{max_times}{The maximum number of times to rerun the LaTeX engine when
using emulation. You can set the global option
\code{tinytex.compile.max_times}, e.g.,
\code{options(tinytex.compile.max_times = 3)}.}

\item{install_packages}{Whether to automatically install missing LaTeX
packages found by \code{\link{parse_packages}()} from the LaTeX log. This
argument is only for the emulation mode and TeX Live.}

\item{...}{Arguments to be passed to \code{latexmk()} (other than
\code{engine} and \code{emulation}).}
}
\description{
The function \code{latexmk()} emulates the system command \command{latexmk}
(\url{https://ctan.org/pkg/latexmk}) to compile a LaTeX document to PDF. The
functions \code{pdflatex()}, \code{xelatex()}, and \code{lualatex()} are
wrappers of \code{latexmk(engine =, emulation = TRUE)}.
}
\details{
The \command{latexmk} emulation works like this: run the LaTeX engine once
(e.g., \command{pdflatex}), run \command{makeindex} to make the index if
necessary (the \file{*.idx} file exists), run the bibliography engine
\command{bibtex} or \command{biber} to make the bibliography if necessary
(the \file{*.aux} or \file{*.bcf} file exists), and finally run the LaTeX
engine a number of times (the maximum is 10 by default) to resolve all
cross-references.

If \code{emulation = FALSE}, you need to make sure the executable
\command{latexmk} is available in your system, otherwise \code{latexmk()}
will fall back to \code{emulation = TRUE}. You can set the global option
\code{options(tinytex.latexmk.emulation = FALSE)} to always avoid emulation
(i.e., always use the executable \command{latexmk}).
}
