% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{expect_equal}
\alias{expect_equal}
\alias{expect_equivalent}
\alias{expect_true}
\alias{expect_false}
\alias{expect_error}
\alias{expect_warning}
\title{Express expectations}
\usage{
expect_equal(target, current, label = NA_character_,
  tol = sqrt(.Machine$double.eps), ...)

expect_equivalent(target, current, tol = sqrt(.Machine$double.eps), ...)

expect_true(current)

expect_false(current)

expect_error(current, pattern = ".*")

expect_warning(current, pattern = ".*")
}
\arguments{
\item{target}{\code{[R object or expression]} Expected outcome}

\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{label}{\code{[character]} A label or description.}

\item{tol}{\code{[numeric]} Test equality to machine rounding. Passed 
to \code{\link[base]{all.equal} (tolerance)}}

\item{...}{Passed to \code{all.equal}}

\item{pattern}{\code{[character]} A regular expression to match the message.}
}
\value{
A \code{\link{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the 
test that was run
}
\description{
Express expectations
}
\details{
\code{expect_equivalent} is calls \code{expect_equal} with the extra
arguments \code{check.attributes=FALSE} and \code{use.names=FALSE}
}
\examples{
expect_equal(1 + 1, 2)       # TRUE
expect_equal(1 - 1, 2)       # FALSE
expect_equivalent(2, c(x=2)) # TRUE
expect_equal(2, c(x=2))      # FALSE

}
\seealso{
Other test-functions: \code{\link{ignore}}
}
\concept{test-functions}
