% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_inops.R
\name{import_inops}
\alias{import_inops}
\title{(Un)Expose Infix Operators From Package Namespace in the Current Environment}
\usage{
import_inops(expose = NULL, unexpose = NULL, lib.loc = .libPaths(), ...)
}
\arguments{
\item{expose, unexpose}{either one of the following:
\itemize{
\item an alias object as produced by the \link{import_as} function.
\item a string giving the package name. Core R (i.e. "base", "stats", etc.) is not allowed.
}}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
Only used when supplying a string to
\code{expose} / \code{unexpose},
and ignored when supplying an alias object to
\code{expose} / \code{unexpose}
(the library is path already stored inside the alias object). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}

\item{...}{additional arguments,
only relevant if the \code{expose} argument is used. \cr
See \link{import_inops.control}. \cr \cr}
}
\value{
If using argument \code{expose}: \cr
The infix operators specified in the given package or alias will be placed
in the current environment. \cr
\cr
If using argument \code{unexpose}: \cr
The infix operators specified in the given package or alias,
exposed by \code{import_inops()}, will be removed from the current environment. \cr
If such infix operators could not be found, this function simply returns \code{NULL}. \cr \cr
}
\description{
\code{import_inops(expose = ...)}
exposes infix operators specified
in a package or an alias object to the current environment. \cr
\cr
\code{import_inops(unexpose = ...)}
"unexposes" (i.e. removes) the infix operators specified
in a package or an alias object
from the current environment. \cr
Note that in this case only infix operators exposed by
the 'tinycodet' import system
will be removed from the current environment;
"regular" (i.e. user-defined) infix operators will not be touched. \cr
\cr
To attach all infix operators from a package to the global namespace,
one can use the \link{pkg_lsf} function like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{y <- pkg_lsf("packagename", type = "inops")
library(packagename, include.only = y)
}\if{html}{\out{</div>}}
}
\details{
\bold{Why Exposing Infix Operators Is Useful} \cr
To use a function from an R-package,
while avoiding the disadvantages of attaching a package
(see \link{tinycodet_import}),
one would traditionally use the \link[base]{::} operator like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{packagename::function_name()
}\if{html}{\out{</div>}}

This is, however, cumbersome with infix operators,
as it forces one to code like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{packagename::`\%op\%`(x,y)
}\if{html}{\out{</div>}}

Exposing infix operators to the current environment,
using the \code{import_inops()} function,
allows one to use infix operators without using cumbersome code,
and without having to attach the infix operators globally. \cr
\cr
\cr
\bold{Other Details} \cr
The \code{import_inops()} function does not support overloading base/core R operators. \cr
\cr
When using \code{import_inops()} to remove infix operators from the current environment,
it will use the attributes of those operators to determine if the infix operator came from
the 'tinycodet' import system or not.
Only infix operators exposed by the 'tinycodet' import system will be removed. \cr \cr
}
\examples{

import_inops(expose = "stringi") # expose infix operators from package
import_inops(unexpose = "stringi") # remove the exposed infix operators from environment

import_as(~ stri., "stringi")
import_inops(expose = stri.) # expose infix operators from alias
import_inops(unexpose = stri.) # unexposed infix operators from current environment


# additional arguments (only used when exposing, not unexposing):
import_inops(expose = "stringi", exclude = "\%s==\%")
import_inops(unexpose = "stringi")
import_inops(expose = "stringi", overwrite = FALSE)
import_inops(unexpose = "stringi")

import_as(~ stri., "stringi")
import_inops(expose = stri., include.only = "\%s==\%")
import_inops(unexpose = stri.)
import_inops(expose = stri., overwrite = FALSE)
import_inops(unexpose = stri.)




}
\seealso{
\link{tinycodet_import}, \code{\link[=import_inops.control]{import_inops.control()}}, \code{\link[=report_inops]{report_inops()}}
}
