% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pversion.R
\name{pversion}
\alias{pversion}
\alias{pversion_check4mismatch}
\alias{pversion_report}
\title{Check for Package Versions Mismatch}
\usage{
pversion_check4mismatch(pkgs = NULL, lib.loc = .libPaths())

pversion_report(pkgs = NULL, lib.loc = .libPaths())
}
\arguments{
\item{pkgs}{a character vector with the package name(s). \cr
Packages that are not actually loaded will be ignored. \cr
Base/core R will also be ignored. \cr
If \code{NULL}, all loaded packages
(see \link[base]{loadedNamespaces})
excluding core/base R will be checked.}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}
}
\value{
For  \code{pversion_check4mismatch()}: \cr
If no mismatch between loaded versions and those in \code{lib.loc} were found,
returns \code{NULL}. \cr
Otherwise it returns a \code{data.frame},
with the loaded version and library version of the specified packages. \cr
\cr
For \code{pversion_report()}: \cr
Returns a \code{data.frame},
with the loaded version and library version of the specified packages,
as well as a logical column indicating whether the two versions are equal (\code{TRUE}),
or not equal (\code{FALSE}). \cr
\cr
}
\description{
The \code{pversion_check4mismatch()} function
checks if there is any mismatch between
the currently loaded packages and the packages in the specified library path. \cr
\cr
The \code{pversion_report()} function
gives a table of all specified packages,
with their loaded and installed versions,
regardless if there is a mismatch or not.
}
\examples{
\dontshow{if ("dplyr" \%installed in\%  .libPaths()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
"dplyr" \%installed in\%  .libPaths()

import_as(~dpr., "dplyr")
pversion_check4mismatch()
pversion_report()




\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tinycodet_import]{tinycodet_import()}}
}
