% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setWindow}
\alias{setWindow}
\title{Set the current visible window}
\usage{
setWindow(id, start, end, options)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{start}{The start date/time to show in the timeline}

\item{end}{The end date/time to show in the timeline}

\item{options}{Named list of options controlling mainly the animation.
Most common option is \code{animation = TRUE/FALSE}. For a full list of
options, see the "setWindow" method in the
\href{http://visjs.org/docs/timeline/#Methods}{official
Timeline documentation}}
}
\description{
Set the current visible window
}
\examples{

timevis() \%>\%
  setWindow(Sys.Date() - 1, Sys.Date() + 1)

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Set window to show between yesterday to tomorrow")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      setWindow("timeline", Sys.Date() - 1, Sys.Date() + 1)
    })
  }
)
}
}

