% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-condense_period.R
\name{condense_period}
\alias{condense_period}
\title{Convert the Period to a Lower Periodicity (e.g. Go from Daily to Monthly)}
\usage{
condense_period(.data, .date_var, .period = "1 day", .side = c("start", "end"))
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{.date_var}{A column containing date or date-time values.
If missing, attempts to auto-detect date column.}

\item{.period}{A period to condense the time series to.
Time units are condensed using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed:
\itemize{
\item \code{"1 year"}
\item \code{"2 months"}
\item \code{"30 seconds"}
}}

\item{.side}{One of "start" or "end". Determines if the first observation in the period should be returned
or the last.}
}
\value{
A \code{tibble} or \code{data.frame}
}
\description{
Convert a \code{data.frame} object from daily to monthly,
from minute data to hourly, and more. This allows the user to easily
aggregate data to a less granular level by taking the value from either
the beginning or end of the period.
}
\examples{
# Libraries
library(timetk)
library(dplyr)

# First value in each month
m4_daily \%>\%
    group_by(id) \%>\%
    condense_period(.period = "1 month")

# Last value in each month
m4_daily \%>\%
    group_by(id) \%>\%
    condense_period(.period = "1 month", .side = "end")



}
\seealso{
Time-Based dplyr functions:
\itemize{
\item \code{\link[=summarise_by_time]{summarise_by_time()}} - Easily summarise using a date column.
\item \code{\link[=mutate_by_time]{mutate_by_time()}} - Simplifies applying mutations by time windows.
\item \code{\link[=pad_by_time]{pad_by_time()}} - Insert time series rows with regularly spaced timestamps
\item \code{\link[=filter_by_time]{filter_by_time()}} - Quickly filter using date ranges.
\item \code{\link[=filter_period]{filter_period()}} - Apply filtering expressions inside periods (windows)
\item \code{\link[=slice_period]{slice_period()}} - Apply slice inside periods (windows)
\item \code{\link[=condense_period]{condense_period()}} - Convert to a different periodicity
\item \code{\link[=between_time]{between_time()}} - Range detection for date or date-time sequences.
\item \code{\link[=slidify]{slidify()}} - Turn any function into a sliding (rolling) function
}
}
