% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storeTimeSeries.R
\name{storeTimeSeries}
\alias{storeTimeSeries}
\title{Write an R time series to a PostgreSQL database}
\usage{
storeTimeSeries(series, con, li = NULL, valid_from = NULL,
  release_date = NULL, store_freq = T, tbl = "timeseries_main",
  tbl_vintages = "timeseries_vintages",
  md_unlocal = "meta_data_unlocalized", lookup_env = .GlobalEnv,
  overwrite = T, schema = "timeseries")
}
\arguments{
\item{series}{character name of a time series, S3 class ts. When used with lists it is convenient to set series to names(li). Note that the series name needs to be unique in the database!}

\item{con}{a PostgreSQL connection object.}

\item{li}{list of time series. Defaults to NULL to no break legacy calls that use lookup environments.}

\item{valid_from}{character date lower bound of a date range.}

\item{release_date}{character date string indicating when a series should be released. This facilitates implementations that only share part of the information before a certain release date.}

\item{store_freq}{logical, should frequencies be stored. Defaults to TRUE.}

\item{tbl}{character string denoting the name of the main time series table in the PostgreSQL database.}

\item{tbl_vintages}{character string denoting the name of the vintages time series table in the PostgreSQL database.}

\item{md_unlocal}{character string denoting the name of the table that holds unlocalized meta information.}

\item{lookup_env}{environment to look in for timeseries. Defaults to .GobalEnv.}

\item{overwrite}{logical should existing records (same primary key) be overwritten? Defaults to TRUE.}

\item{schema}{SQL schema name. Defaults to timeseries.}
}
\description{
This function writes time series object into a relational PostgreSQL database make use 
of PostgreSQL own 'key'=>'value' storage called hstore. The schema and database needs to 
created first. The parent R Package of this functions suggests a database structure
designed to store a larger amount of time series. This function uses INSERT INTO instead of the more convenient dbWritetable for performance reasons. DO NOT USE THIS FUNCTIONS IN LOOPS OR LAPPLY! This function can handle a set of time series on its own and is much faster than looping over a list. Non-unique primary keys are overwritten !
}
\author{
Matthias Bannert, Charles Clavadetscher, Gabriel Bucur
}
