% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDbQuery.R
\name{runDbQuery}
\alias{runDbQuery}
\title{Run SELECT query}
\usage{
runDbQuery(con, sql_query, ...)
}
\arguments{
\item{con}{PostgreSQL connection object}

\item{sql_query}{character string containing a SQL query}

\item{...}{Additional arguments to be passed to \code{\link[DBI]{dbGetQuery}}}
}
\description{
Run database queries using \code{\link[DBI]{dbSendQuery}}, \code{\link[DBI]{fetch}} and \code{\link[DBI]{dbClearResult}} in similar fashion as \code{\link[DBI]{dbGetQuery}} but provide better error handling. 
This function always returns a data.frame as opposed to different types in case of an exception. However, if the database query fails and empty data.frame is returned. Besides query status and database error are returned as attributes. Make sure to use BEGIN and COMMIT outside of these statements.
}
\examples{
# There's no connection, so this returns a proper error message.
\donttest{
out_obj <- runDbQuery(bogus_connection,"SELECT * FROM some_table") 
attributes(out_obj)
}
}
