% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_gaps.R
\name{time_gaps}
\alias{time_gaps}
\alias{time_num_gaps}
\alias{time_has_gaps}
\title{Gaps in a regular time sequence}
\usage{
time_gaps(
  x,
  timespan = granularity(x),
  g = NULL,
  use.g.names = TRUE,
  check_time_regular = FALSE
)

time_num_gaps(
  x,
  timespan = granularity(x),
  g = NULL,
  use.g.names = TRUE,
  na.rm = TRUE,
  check_time_regular = FALSE
)

time_has_gaps(
  x,
  timespan = granularity(x),
  g = NULL,
  use.g.names = TRUE,
  na.rm = TRUE,
  check_time_regular = FALSE
)
}
\arguments{
\item{x}{Time vector. \cr
E.g. a \code{Date}, \code{POSIXt}, \code{numeric} or any time-based vector.}

\item{timespan}{\link{timespan}.}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame.}

\item{use.g.names}{Should the result include group names?
Default is \code{TRUE}.}

\item{check_time_regular}{Should the time vector be
checked to see if it is regular (with or without gaps)?
Default is \code{FALSE}.}

\item{na.rm}{Should \code{NA} values be removed? Default is \code{TRUE}.}
}
\value{
\code{time_gaps} returns a vector of time gaps. \cr
\code{time_num_gaps} returns the number of time gaps. \cr
\code{time_has_gaps} returns a logical(1) of whether there are gaps.
}
\description{
\code{time_gaps()} checks for implicit missing gaps in time for any
regular date or datetime sequence.
}
\details{
When \code{check_time_regular} is TRUE, \code{x} is passed to
\code{time_is_regular}, which checks that the time elapsed between successive
values are in increasing order and are whole numbers.
For more strict checks, see \code{?time_is_regular}.
}
\examples{

library(timeplyr)
library(fastplyr)
library(lubridate)
library(nycflights13)
missing_dates(flights$time_hour)
time_has_gaps(flights$time_hour)
time_num_gaps(flights$time_hour)
length(time_gaps(flights$time_hour))
time_num_gaps(flights$time_hour, g = flights$origin)

# Number of missing hours by origin and dest
flights \%>\%
  f_group_by(origin, dest) \%>\%
  f_summarise(n_missing = time_num_gaps(time_hour, "hours"))

}
