% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/national.R
\name{nation}
\alias{nation}
\title{Download a US national boundary shapefile into R}
\usage{
nation(resolution = "5m", year = NULL)
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
Defaults to '5m'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2016).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Download a US national boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

boundary <- nation(resolution = '20m')

leaflet(boundary) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{divisions}},
  \code{\link{regions}}
}
