% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyfitGC.R
\name{polyfitGC}
\alias{polyfitGC}
\title{Polynomial Regression}
\usage{
polyfitGC(form,data=parent.frame(),degree=2,graph=TRUE,check=FALSE)
}
\arguments{
\item{form}{formula of form y~x, both variables numeric}

\item{data}{dataframe supplying y and x above.  If one or more of the variables is not in data, then
they will be searched for in the parent environment.}

\item{degree}{desired degree of polynomial (for degree 1 use lmgC)}

\item{graph}{Produce scatterplot with fitted ploynomial.}

\item{check}{Asks to produce a lowess or gam curve with approximate 95%-confidence band.  If the
fitted line wanders outside the band, then perhaps a linear fit is not appropriate.}
}
\value{
A list of class "polyGC".  Elements that may be queried include
"s" (residual standard error) and "R^2" (unadjusted).
}
\description{
Regression analysis (one numerical predictor variable) with simplified output.
  Wrapper function for \code{lm} in package \code{stats}.
}
\examples{
#To study the relationship between two numerical variables:
polyfitGC(mpg~wt,data=mtcars,degree=2,graph=TRUE)
#check the second-fdegree fit:
polyfitGC(mpg~wt,data=mtcars,degree=2,check=TRUE)
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

