% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_ph.R
\name{chemdose_ph_chain}
\alias{chemdose_ph_chain}
\title{Apply `chemdose_ph` within a dataframe and output a column of `water` class to be chained to other tidywater functions}
\usage{
chemdose_ph_chain(
  df,
  input_water = "defined_water",
  output_water = "dosed_chem_water",
  hcl = 0,
  h2so4 = 0,
  h3po4 = 0,
  co2 = 0,
  naoh = 0,
  na2co3 = 0,
  nahco3 = 0,
  caoh2 = 0,
  mgoh2 = 0,
  cl2 = 0,
  naocl = 0,
  nh4oh = 0,
  nh42so4 = 0,
  alum = 0,
  ferricchloride = 0,
  ferricsulfate = 0,
  ach = 0,
  caco3 = 0
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_chain}}. The df may include columns named for the chemical(s) being dosed.}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "dosed_chem_water".}

\item{hcl}{Hydrochloric acid: HCl -> H + Cl}

\item{h2so4}{Sulfuric acid: H2SO4 -> 2H + SO4}

\item{h3po4}{Phosphoric acid: H3PO4 -> 3H + PO4}

\item{co2}{Carbon Dioxide CO2 (gas) + H2O -> H2CO3*}

\item{naoh}{Caustic: NaOH -> Na + OH}

\item{na2co3}{Soda ash: Na2CO3 -> 2Na + CO3}

\item{nahco3}{Sodium bicarbonate: NaHCO3 -> Na + H + CO3}

\item{caoh2}{Lime: Ca(OH)2 -> Ca + 2OH}

\item{mgoh2}{Magneisum hydroxide: Mg(OH)2 -> Mg + 2OH}

\item{cl2}{Chlorine gas: Cl2(g) + H2O -> HOCl + H + Cl}

\item{naocl}{Sodium hypochlorite: NaOCl -> Na + OCl}

\item{nh4oh}{Amount of ammonium hydroxide added in mg/L as N: NH4OH -> NH4 + OH}

\item{nh42so4}{Amount of ammonium sulfate added in mg/L as N: (NH4)2SO4 -> 2NH4 + SO4}

\item{alum}{Hydrated aluminum sulfate Al2(SO4)3*14H2O + 6HCO3 -> 2Al(OH)3(am) +3SO4 + 14H2O + 6CO2}

\item{ferricchloride}{Ferric Chloride FeCl3 + 3HCO3 -> Fe(OH)3(am) + 3Cl + 3CO2}

\item{ferricsulfate}{Amount of ferric sulfate added in mg/L: Fe2(SO4)3*8.8H2O + 6HCO3 -> 2Fe(OH)3(am) + 3SO4 + 8.8H2O + 6CO2}

\item{ach}{Amount of aluminum chlorohydrate added in mg/L: Al2(OH)5Cl*2H2O + HCO3 -> 2Al(OH)3(am) + Cl + 2H2O + CO2}

\item{caco3}{Amount of calcium carbonate added (or removed) in mg/L: CaCO3 -> Ca + CO3}
}
\value{
A data frame containing a water class column with updated pH, alkalinity, and ions post-chemical addition.
}
\description{
This function allows \code{\link{chemdose_ph}} to be added to a piped data frame.
Its output is a `water` class, and can therefore be used with "downstream" tidywater functions.
Ions and pH will be updated based on input chemical doses.
}
\details{
The data input comes from a `water` class column, as initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.

If the input data frame has a column(s) name matching a valid chemical(s), the function will dose that chemical(s) in addition to the
ones specified in the function's arguments.
The column names must match the chemical names as displayed in \code{\link{chemdose_ph}}.
To see which chemicals can be passed into the function, see \code{\link{chemdose_ph}}.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(input_water = "balanced_water", naoh = 5)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  mutate(
    hcl = seq(1, 12, 1),
    naoh = 20
  ) \%>\%
  chemdose_ph_chain(input_water = "balanced_water", mgoh2 = 55, co2 = 4)

# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(input_water = "balanced_water", naoh = 5)

# Optional: explicitly close multisession processing
plan(sequential)

}
\seealso{
\code{\link{chemdose_ph}}
}
