% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-drop-tip.R
\docType{methods}
\name{drop.tip}
\alias{drop.tip}
\alias{keep.tip}
\alias{drop.tip,treedata-method}
\alias{drop.tip,treedata}
\alias{drop.tip,phylo-method}
\alias{drop.tip,phylo}
\alias{keep.tip,treedata-method}
\alias{keep.tip,phylo-method}
\title{drop.tip method}
\source{
drop.tip for phylo object is a wrapper method of ape::drop.tip
from the ape package. The documentation you should
read for the drop.tip function can be found here: \link[ape]{drop.tip}
}
\usage{
drop.tip(object, tip, ...)

keep.tip(object, tip, ...)

\S4method{drop.tip}{treedata}(object, tip, ...)

\S4method{drop.tip}{phylo}(object, tip, ...)

\S4method{keep.tip}{treedata}(object, tip, ...)

\S4method{keep.tip}{phylo}(object, tip, ...)
}
\arguments{
\item{object}{A treedata or phylo object}

\item{tip}{a vector of mode numeric or character specifying the tips to delete}

\item{...}{additional parameters}
}
\value{
updated object
}
\description{
drop.tip method
}
\examples{
library(tidytree)
set.seed(123)
tr <- ape::rtree(6)
da <- data.frame(id=tip.label(tr), value = letters[seq_len(6)])
trda <- tr \%>\% dplyr::left_join(da, by = c('label'='id'))
tr1 <- drop.tip(tr, c("t2", "t1"))
tr2 <- keep.tip(tr, c("t2", "t1"))
}
\seealso{
\link[ape]{drop.tip}
}
\author{
Casey Dunn \url{http://dunnlab.org}  and Guangchuang Yu \url{https://guangchuangyu.github.io}
}
