% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raptor.R
\name{filter_stop_times}
\alias{filter_stop_times}
\title{Filter a \code{stop_times} table for a given date and timespan.}
\usage{
filter_stop_times(gtfs_obj, extract_date, min_departure_time,
  max_arrival_time)
}
\arguments{
\item{gtfs_obj}{a gtfs feed}

\item{extract_date}{date to extract trips from in YYYY-MM-DD format}

\item{min_departure_time}{The minimal departure time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds.}

\item{max_arrival_time}{The latest arrival time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds}
}
\description{
Filter a \code{stop_times} table for a given date and timespan.
}
\examples{
feed_path <- system.file("extdata", "sample-feed-fixed.zip", package = "tidytransit")
g <- read_gtfs(feed_path, local=TRUE)

# Consider precalculating date_service_table for the feed.
g <- set_date_service_table(g)

# filter the sample feed
stop_times <- filter_stop_times(g, "2007-01-06", "06:00:00", "08:00:00")
}
