% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{add_summary}
\alias{add_summary}
\title{Add summary to tibble}
\usage{
add_summary(.data, .language)
}
\arguments{
\item{.data}{Data argument, typical "first" argument in dplyr verbs}

\item{.language}{A call to \code{summarise()},
or another method performing equivalent aggregation (potentially wrapping \code{summarise()})}
}
\value{
The tibble with added columns
}
\description{
A verb for a dplyr pipeline:
Performs a call to \code{summarise()}, but does not reduce the data frame to one row per group,
instead, adds the resulting fields to every row belonging to that group,
returning the original frame with added/changed columns.
Effectively, this is like calling \code{summarise()}, and then calling \code{mutate()} with all the resulting columns.
}
