% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize.}
\alias{summarize.}
\alias{summarise.}
\alias{dt_summarise}
\alias{dt_summarize}
\title{Aggregate data using summary statistics}
\usage{
summarize.(.df, ..., by = NULL)

summarise.(.df, ..., by = NULL)

dt_summarise(.df, ..., by = NULL)

dt_summarize(.df, ..., by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{by}{Columns to group by.
\itemize{
\item A single column can be passed with \code{by = d}.
\item Multiple columns can be passed with \code{by = c(c, d)}
\item \code{tidyselect} can be used:
\itemize{
\item Single predicate: \code{by = where(is.character)}
\item Multiple predicates: \code{by = c(where(is.character), where(is.factor))}
\item A combination of predicates and column names: \code{by = c(where(is.character), b)}
}
}}
}
\description{
Aggregate data using summary statistics such as mean or median. Can be calculated by group.
}
\examples{
test_df <- data.table(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"),
  d = c("a","a","b"))

test_df \%>\%
  summarize.(avg_a = mean(a),
             max_b = max(b),
             by = c)

test_df \%>\%
  summarize.(avg_a = mean(a),
             by = c(c, d))
}
