% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.psych.R
\name{tidy_stats.psych}
\alias{tidy_stats.psych}
\title{tidy_stats method for psych's alpha objects}
\usage{
\method{tidy_stats}{psych}(model)
}
\arguments{
\item{model}{An psych alpha object}
}
\description{
Creates a tidystats data frame for a psych's alpha object.
}
\examples{
# Load packages
library(psych)
library(dplyr)

# Create an empty list to store results in
results <- list()

# Example: Cronbach's alpha
alpha_agreeableness <- bfi \%>\%
  select(A1, A2, A3, A4, A5) \%>\%
  alpha(check.keys = TRUE, warnings = FALSE)

# Tidy stats
tidy_stats(alpha_agreeableness)

# Example: Correlations
cors_agreeableness <- bfi \%>\%
  select(A1, A2, A3, A4, A5) \%>\%
  corr.test()

# Tidy stats
tidy_stats(cors_agreeableness)

}
