#' Data of a replication study of C.R. Cox, J. Arndt, T. Pyszczynski, J. Greenberg, A. Abdollahi, S. Solomon (2008, JPSP, 94(4), Exp. 6)
#'
#' @description This is the data of a replication study performed by J. Wissink, G. Hoogendoorn, H. Brohmer, M. Verschoor, J. Krijnen, and M. Zeelenberg as part of the Reproducibility Project: Psychology. The target of replication was the finding in Experiment 6 of Cox et al. (2008) that participants who scored low on avoidance but high on anxiety demonstrated an increased relative preference for a parent after mortality salience as opposed to dental pain, b = -32.04, SE = 14.47, t = -2.22, p = .03.
#'
#' @format A data frame with 200 rows and 67 variables.
#' \describe{
#'  \item{ID}{Participant identifier}
#'  \item{sex}{The participant's sex}
#'  \item{age}{The participant's age}
#'  \item{condition}{The experimental condition: mortality salience or dental pain}
#'  \item{avoidance}{Attachment avoidance score as assessed with the Relationship Scales Questionnaire}
#'  \item{anxiety}{Attachment anxiety score as assessed with the Relationship Scales Questionnaire}
#'  \item{affect_positive}{Sum of positive PANAS items}
#'  \item{affect_negative}{Sum of negative PANAS items}
#'  \item{call_parent}{Minutes allocated (out of 100) to call a parent}
#'  \item{call_siblings}{Minutes allocated (out of 100) to call a sibling}
#'  \item{call_partner}{Minutes allocated (out of 100) to call a romantic partner}
#'  \item{call_friend}{Minutes allocated (out of 100) to call a close friend}
#'  }
#'
#' @details For more information on the Reproducibility Project: Psychology, see \url{https://osf.io/ezcuj/}. The individual scores on the PANAS and RSQ items are not included in this dataset.
#'
#' @references
#' Cox, C.R., Arndt, J., Pyszczynski, T., Greenberg, J., Abdollahi, A., & Solomon, S. (2008) Terror management and adults’ attachment to their parents: The safe haven remains. Journal of Personality and Social Psychology, 94(4), 696-717, https://dx.doi.org/10.1037/0022-3514.94.4.696)
#'
#' @source
#' \url{https://osf.io/5tbxf/}
"cox"