#' tidysdm
#'
#' This `R` library facilitates the fitting of Species Distribution
#' Models with `tidymodels`.
#' 
#' The functionalities of `tidysdm` are described in
#'  Leonardi et al. (2023) \doi{10.1101/2023.07.24.550358}. Please cite it if you
#' use `tidysdm` in your research.
#'
#' On its dedicated [website](https://evolecolgroup.github.io/tidysdm/), you can find
#' Articles giving you a step-by-step [overview of the package](https://evolecolgroup.github.io/tidysdm/articles/a0_tidysdm_overview.html),
#' how to use [`tidysdm` on palaeodata](https://evolecolgroup.github.io/tidysdm/articles/a1_palaeodata_application.html),
#' examples of [advanced modelling approaches using `tidymodels` features](https://evolecolgroup.github.io/tidysdm/articles/a2_tidymodels_additions.html),
#' and a [troubleshooting guide for when models fail](https://evolecolgroup.github.io/tidysdm/articles/a3_troubleshooting.html).
#' There is also a
#' [development version](https://evolecolgroup.github.io/tidysdm/dev/) of the site
#' updated for the `dev` version (on the top left, the version number is in
#' red, and will be in the format x.x.x.9xxx, indicating it is a
#' development version).
#'
#' @docType package
#' @name tidysdm
#' @import tidymodels
#' @import spatialsample
#' @importFrom rlang .data

NULL
