% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_spec_rand_forest.R
\name{sdm_spec_rand_forest}
\alias{sdm_spec_rand_forest}
\alias{sdm_spec_rf}
\title{Model specification for a Random Forest for SDM}
\usage{
sdm_spec_rand_forest(..., tune = c("sdm", "all", "custom", "none"))

sdm_spec_rf(..., tune = c("sdm", "all", "custom", "none"))
}
\arguments{
\item{...}{parameters to be passed to \code{\link[parsnip:rand_forest]{parsnip::rand_forest()}} to
customise the model. See the help of that function for details.}

\item{tune}{character defining the tuning strategy. Valid strategies are:
\itemize{
\item "sdm" chooses hyperparameters that are most important to tune for
an sdm (for \emph{rf}, 'mtry')
\item "all" tunes all hyperparameters (for \emph{rf}, 'mtry', 'trees' and 'min')
\item "custom" passes the options from '...'
\item "none" does not tune any hyperparameter
}}
}
\value{
a \link[parsnip:model_spec]{parsnip::model_spec} of the model.
}
\description{
This function returns a \link[parsnip:model_spec]{parsnip::model_spec} for a Random Forest to
be used as a classifier of presences and absences in Species Distribution
Models. It uses the library \code{ranger} to fit boosted trees; to use another
library, simply build the
\link[parsnip:model_spec]{parsnip::model_spec} directly.
}
\details{
\code{sdm_spec_rf()} is simply a short form for \code{sm_spec_rand_forest()}.
}
\examples{
test_rf_spec <- sdm_spec_rf(tune = "sdm")
test_rf_spec
# combining tuning with specific values for other hyperparameters
sdm_spec_rf(tune = "sdm", trees = 100)
}
