% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill}
\alias{fill}
\title{Fill in missing values.}
\usage{
fill(data, ..., .direction = c("down", "up"))
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to expand.

To find all unique combinations of x, y and z, including those not
found in the data, supply each variable as a separate argument.
To find only the combinations that occur in the data, use nest:
\code{expand(df, nesting(x, y, z))}.

You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for every student for each date.

For factors, the full set of levels (not just those that appear in the
data) are used. For continuous variables, you may need to fill in values
that don't appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = \link{full_seq}(year)}.

Length-zero (empty) elements are automatically dropped.}

\item{.direction}{Direction in which to fill missing values. Currently
either "down" (the default) or "up".}
}
\description{
Fills missing values in using the previous entry. This is useful in the
common output format where values are not repeated, they're recorded
each time they change.
}
\details{
Missing values are replaced in atomic vectors; \code{NULL}s are replaced
in list.
}
\examples{
df <- data.frame(Month = 1:12, Year = c(2000, rep(NA, 11)))
df \%>\% fill(Year)
}
