% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-theme_tq.R
\name{theme_tq}
\alias{theme_tq}
\alias{theme_tq_dark}
\alias{theme_tq_green}
\title{tidyquant themes for ggplot2.}
\usage{
theme_tq(base_size = 11, base_family = "")

theme_tq_dark(base_size = 11, base_family = "")

theme_tq_green(base_size = 11, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
The \code{theme_tq()} function creates a custom theme using tidyquant colors.
}
\examples{
# Load libraries
library(tidyquant)
library(dplyr)
library(ggplot2)

# Get stock prices
AAPL <- tq_get("AAPL", from = "2013-01-01", to = "2016-12-31")

# Plot using ggplot with theme_tq
AAPL \%>\% ggplot(aes(x = date, y = close)) +
       geom_line() +
       geom_bbands(aes(high = high, low = low, close = close),
                   ma_fun = EMA,
                   wilder = TRUE,
                   ratio = NULL,
                   n = 50) +
       coord_x_date(xlim = c("2016-01-01", "2016-12-31"),
                 ylim = c(75, 125)) +
       labs(title = "Apple BBands",
            x = "Date",
            y = "Price") +
       theme_tq()

}
\seealso{
\code{\link[=scale_manual]{scale_manual()}}
}
