% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{rename_x_axis_labels}
\alias{rename_x_axis_labels}
\alias{rename_y_axis_labels}
\alias{rename_color_labels}
\title{Rename axis or color labels}
\usage{
rename_x_axis_labels(plot, new_names)

rename_y_axis_labels(plot, new_names)

rename_color_labels(plot, new_names)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{new_names}{Named character vector in the format c("old1" = "new1", "old2" = "new2").}
}
\value{
A \code{tidyplot} object.
}
\description{
Rename axis or color labels
}
\examples{
# Before adjustments
study \%>\%
  tidyplot(x = treatment, y = score) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Rename x-axis labels
study \%>\%
  tidyplot(x = treatment, y = score) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  rename_x_axis_labels(new_names = c(
    "A" = "This",
    "B" = "is",
    "C" = "totally",
    "D" = "new"))

# Before adjustments
study \%>\%
  tidyplot(x = score, y = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Rename y-axis labels
study \%>\%
  tidyplot(x = score, y = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  rename_y_axis_labels(new_names = c(
    "A" = "This",
    "B" = "is",
    "C" = "totally",
    "D" = "new"))

# Before adjustment
study \%>\%
  tidyplot(x = group, y = score, color = dose) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

# Rename color labels
study \%>\%
  tidyplot(x = group, y = score, color = dose) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  rename_color_labels(new_names = c(
    "high" = "Sky high",
    "low" = "Deep low"))

}
