% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_plate.R
\name{generate_plate}
\alias{generate_plate}
\title{Generates a microwell plate shaped csv or excel file from tibble or dataframe}
\usage{
generate_plate(x, well_id, plate_type, file)
}
\arguments{
\item{x}{A dataframe or tibble.}

\item{well_id}{A character string or an integer which points to the column
containing the well ids.}

\item{plate_type}{A specific integer (6, 12, 24, 48, 96, 384, 1536)
indicating the type of microwell plate.}

\item{file}{A character string with the filename of the output file with
the path and type of exported file. Only csv or xlsx files are supported.}
}
\value{
A csv or xlsx file.
}
\description{
Dataframes or tibbles are not good for visual inspection of microwell plate
shaped data. \code{generate_plate()} helps the user by transforming dataframe or
tibble into a microwell plate data. It does the opposite of what
\code{tidy_plate()} does to a plate data.
}
\examples{
file_path <- system.file("extdata", "tidy_12_well.csv", package = "tidyplate")

tbl <- read.csv(file_path)
temp_file <- tempfile(fileext = ".csv")

plate_12 <- generate_plate(tbl,
                           well_id = "well",
                           plate_type = 12,
                           file = temp_file)
}
\seealso{
\code{\link[=tidy_plate]{tidy_plate()}},\code{\link[=build_plate]{build_plate()}}
}
