% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_plate.R
\name{build_plate}
\alias{build_plate}
\title{Generates a csv or xlsx template for each plate type}
\usage{
build_plate(
  plate_type = 6,
  n_plates = 1,
  file_type = c("csv", "xlsx"),
  plate_names = NULL,
  file = NULL
)
}
\arguments{
\item{plate_type}{A specific integer (6, 12, 24, 48, 96, 384, 1536)
indicating the type of microwell plate.}

\item{n_plates}{A positive integer indicating the number of plates.}

\item{file_type}{A character string ("csv" (the default) or "xlsx")
indicating the filetype.}

\item{plate_names}{A character vector of unique values that will be assigned
to each plate. Its length should be equal to the value of \code{n_plates}.}

\item{file}{A character string naming the file.}
}
\value{
A csv or xlsx template file.
}
\description{
Generates a csv or xlsx template for each plate type
}
\examples{
\dontrun{
build_plate(plate_type = 6, n_plates = 2)
build_plate(plate_type = 6, n_plates = 2, file_type = "xlsx")
}
}
