% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_new.R
\name{tx_new}
\alias{tx_new}
\title{Subset Clients Starting ART Within a Particular Period.}
\usage{
tx_new(data, from = NULL, to = NULL, states = NULL, facilities = NULL)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}
}
\value{
TX_NEW clients in the period of interest
}
\description{
Generates the line-list of clients who commenced ARV within the specified
period of interest. The default is to generate the list for all clients who
commenced ARV in the current Fiscal Year. You can specify the period of
interest using the \code{from} and \code{to} arguments; and the state or
facility of interest with the \code{states} and \code{facilities} arguments.
For multiple states or facilities, use the \code{c()} to combine the names.
}
\examples{
tx_new(ndr_example, from = "2021-06-01", to = "2021-09-30")

# generate the TX_NEW for a specific state (Ayetoro)
tx_new(ndr_example, states = "Ayetoro")

# Determine the TX_NEW for Quarter 1 of FY21 for State 2
tx_new(ndr_example,
  from = "2021-10-01",
  to = "2021-12-31",
  states = c("Arewa", "Ayetoro")
)
}
