% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_recency.R
\name{summarize_recency}
\alias{summarize_recency}
\title{Count the Number of Recency Outcomes Based on a Specified Level}
\usage{
summarize_recency(..., level = "facility_state", names = NULL)
}
\arguments{
\item{...}{Dataframes to be summarized.}

\item{level}{The level at which the summary should be performed. The options
are "ip" (or "country"), "facility_state", "facility_lga", "facility", "client_state", or "client_lga".}

\item{names}{The names to be passed to the summary columns created in
the output}
}
\value{
summary dataframe of recency indicators
}
\description{
The \code{summarize_recency()} function counts the number of occurrence of
specified level for each of the supplied dataframe. It then combines the
given dataframes into a single table. It also adds a "Total" roll that
adds all the rows for each of the numeric columns.
}
\examples{
hts_pos <- hts_tst_pos(recency_example, from = "2021-01-01") # positive clients from January 2021
hts_recent <- hts_recent(hts_pos) # positive clients from above who had recency testing done
rtri_recent <- rtri_recent(hts_recent) # hts_recent clients who were presumed recent from RTRI

summarize_recency(
  hts_pos,
  hts_recent,
  rtri_recent,
  level = "facility_state",
  names = c("positives", "recency_testing", "rtri_recent")
)

### If the `names` argument is not supplied, the names of the supplied data will be used instead
summarize_recency(
  hts_pos,
  hts_recent
)
}
